﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Option Explicit On
Option Strict Off

Public Class MainForm

    Dim StringHTML As String
    Dim StringRTF As String
    Dim StringPlainText As String
    Dim Pxl As New Pixel

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 从 My.Resources 加载图片
        PictureBox1.Image = My.Resources.Sunset

        ' 将一些文本加载到 Web 浏览器中
        StringHTML = "<HTML><BODY>This is <B>HTML</B></BODY></HTML>"
        WebBrowser1.DocumentText = StringHTML

        ' 将一些文本加载到多格式文本框中
        StringRTF = "{\rtf1\ansi\ansicpg1252\deff0\deflang1033{\fonttbl{" & _
                    "\f0\fswiss\fcharset0 Arial;}}\viewkind4\uc1\pard\f0\fs20\ul\b\fs24 " & _
                    "This\ulnone\b0  \fs20 is \fs36 RTF!\par}"
        RichTextBox1.Rtf = StringRTF

        ' 将一些文本加载到纯文本文本框中
        StringPlainText = "This is plain text"
        TextBox1.Text = StringPlainText

        ' 初始化像素对象的属性，并将其显示在文本框中
        Pxl.X = 10
        Pxl.Y = 20
        Pxl.Color = Color.Red
        LoadPixel(Pxl, TextBox3)
    End Sub

    Private Sub CopyImageButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CopyImageButton.Click
        ' 将图片从图片框复制到剪贴板中
        My.Computer.Clipboard.SetImage(PictureBox1.Image)
    End Sub

    Private Sub PasteImageButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteImageButton.Click
        ' 如果剪贴板中存在图像，则将其粘贴到图片框中
        If My.Computer.Clipboard.ContainsImage Then
            PictureBox2.Image = My.Computer.Clipboard.GetImage
        Else
            MsgBox("Clipboard does not contain an image", MsgBoxStyle.Exclamation And MsgBoxStyle.OKOnly)
        End If
    End Sub

    Private Sub CopyHTMLButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CopyHTMLButton.Click
        ' 将 HTML 从 Web 浏览器复制到剪贴板上
        My.Computer.Clipboard.SetText(WebBrowser1.DocumentText, TextDataFormat.Html)
    End Sub

    Private Sub PasteHTMLButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteHTMLButton.Click
        ' 如果剪贴板中具有 HTML，则将其粘贴到 Web 浏览器控件中
        If My.Computer.Clipboard.ContainsText(TextDataFormat.Html) Then
            WebBrowser2.DocumentText = My.Computer.Clipboard.GetText(TextDataFormat.Html)
        Else
            MsgBox("Clipboard does not contain any HTML", MsgBoxStyle.Exclamation And MsgBoxStyle.OKOnly)
        End If
    End Sub

    Private Sub CopyRTFButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CopyRTFButton.Click
        ' 将文本从多格式文本框复制到剪贴板中
        My.Computer.Clipboard.SetText(RichTextBox1.Rtf, TextDataFormat.Rtf)
    End Sub

    Private Sub PasteRTFButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteRTFButton.Click
        ' 如果剪贴板中具有多格式文本，则将其粘贴到多格式文本框中
        If My.Computer.Clipboard.ContainsText(TextDataFormat.Rtf) Then
            RichTextBox2.Rtf = My.Computer.Clipboard.GetText(TextDataFormat.Rtf)
        Else
            MsgBox("Clipboard does not contain any rich text", MsgBoxStyle.Exclamation And MsgBoxStyle.OKOnly)
        End If
    End Sub

    Private Sub CopyTextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CopyTextButton.Click
        ' 将文本从文本框复制到剪贴板中
        My.Computer.Clipboard.SetText(TextBox1.Text)
    End Sub

    Private Sub PasteTextButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteTextButton.Click
        ' 如果剪贴板中具有文本，则将其粘贴到文本框中
        If My.Computer.Clipboard.ContainsText() Then
            TextBox2.Text = My.Computer.Clipboard.GetText()
        Else
            MsgBox("Clipboard does not contain any text", MsgBoxStyle.Exclamation And MsgBoxStyle.OKOnly)
        End If
    End Sub

    Private Sub CopyObjectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CopyObjectButton.Click
        ' 将像素对象复制到剪贴板中
        My.Computer.Clipboard.SetData("Pixel", Pxl)
    End Sub

    Private Sub PasteObjectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteObjectButton.Click
        Dim tempPixel As Pixel

        ' 如果剪贴板中具有像素对象，则获取该对象，将其分配给另一个对象，并
        ' 将此对象的属性值加载到文本框中
        If My.Computer.Clipboard.ContainsData("Pixel") Then
            tempPixel = CType(My.Computer.Clipboard.GetData("Pixel"), Pixel)
            LoadPixel(tempPixel, TextBox4)
        Else
            MsgBox("Clipboard does not contain a pixel object", MsgBoxStyle.Exclamation And MsgBoxStyle.OKOnly)
        End If
    End Sub

    Private Sub LoadPixel(ByVal Pixel As Pixel, ByVal Textbox As TextBox)
        ' 显示指定文本框中指定像素对象的所有属性的值
        Textbox.Text = "X [" & Pixel.X & "] " & vbCrLf & _
                       "Y [" & Pixel.Y & "] " & vbCrLf & _
                       Pixel.Color.ToString
    End Sub

    Private Sub WindowsExplorerLinkLabel_LinkClicked(ByVal sender As System.Object, ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles WindowsExplorerLinkLabel.LinkClicked
        ' 打开 Windows 资源管理器
        Shell("explorer.exe", AppWinStyle.NormalFocus, False)
    End Sub

    Private Sub PasteFilesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteFilesButton.Click
        ' 如果剪贴板具有一个文件下拉列表，则将此列表中所有文件的名称粘贴到一个列表框中
        If My.Computer.Clipboard.ContainsFileDropList Then
            Dim fileDropList As System.Collections.Specialized.StringCollection
            fileDropList = My.Computer.Clipboard.GetFileDropList()
            For Each fileName As String In fileDropList
                ListBox1.Items.Add(fileName)
            Next
        Else
            MsgBox("Clipboard does not contain a file drop list", MsgBoxStyle.Exclamation And MsgBoxStyle.OKOnly)
        End If
    End Sub

    Private Sub exitToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub clearClipboardToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles clearClipboardToolStripMenuItem.Click
        ' 清除剪贴板
        My.Computer.Clipboard.Clear()
    End Sub
End Class
